///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabServerDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND ListenPort_hWnd;
    static HWND MaxConnects_hWnd;
    static HWND TCPLoopDelay_hWnd;


    if(xMessage == WM_INITDIALOG)
    {
        ListenPort_hWnd   = GetDlgItem(xHandle, IDC_LISTENPORT);
        MaxConnects_hWnd  = GetDlgItem(xHandle, IDC_MAXCONNECTS);
        TCPLoopDelay_hWnd = GetDlgItem(xHandle, IDC_TCPLOOPDELAY);

        Set_Long(ListenPort_hWnd, glListenPort);
        Set_Long(MaxConnects_hWnd, giMaxConnections);
        Set_Long(TCPLoopDelay_hWnd, glTCPLoopDelay);

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

